/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabMenu
extends JPanel
implements ChangeListener {
    private JLabel label;
    private List<Component> components = new ArrayList<Component>();
    private JPanel buttons;
    private List<AbstractButton> items;
    private ButtonGroup buttonGroup;

    public TabMenu() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 6));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.label = new JLabel(" ");
        this.add((Component)this.label, "First");
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 3));
        JScrollPane jScrollPane = new JScrollPane(this.buttons);
        this.add((Component)jScrollPane, "Center");
    }

    public void displayMenu(String string, List<AbstractButton> list) {
        this.displayMenu(string, list, null, true);
    }

    public void displayMenu(String string, List<AbstractButton> list, ButtonGroup buttonGroup, boolean bl) {
        try {
            if (bl) {
                this.clearMenu();
                this.label.setText(string);
                this.buttonGroup = buttonGroup;
            }
            this.items = list;
            if (list != null) {
                for (final AbstractButton abstractButton : list) {
                    this.addButton(abstractButton);
                    int n = abstractButton.getDisplayedMnemonicIndex();
                    if (n == -1) continue;
                    this.getInputMap(2).put(KeyStroke.getKeyStroke(abstractButton.getText().toLowerCase().charAt(n)), abstractButton.toString() + "!doClick");
                    this.getActionMap().put(abstractButton.toString() + "!doClick", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            abstractButton.doClick();
                        }
                    });
                }
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            System.err.println("displayMenu:" + exception);
            exception.printStackTrace(System.err);
        }
    }

    public void clearMenu() {
        this.items = null;
        this.label.setText(" ");
        for (Component serializable2 : this.components) {
            this.buttons.remove(serializable2);
        }
        this.components.clear();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        KeyStroke[] keyStrokeArray = inputMap.keys();
        for (int i = 0; keyStrokeArray != null && i < keyStrokeArray.length; ++i) {
            Object object = inputMap.get(keyStrokeArray[i]);
            if (!(object instanceof String) || !((String)object).endsWith("!doClick")) continue;
            inputMap.remove(keyStrokeArray[i]);
            actionMap.remove(object);
        }
    }

    private void addButton(AbstractButton abstractButton) {
        abstractButton.setOpaque(false);
        abstractButton.setHorizontalAlignment(10);
        abstractButton.setAlignmentX(0.0f);
        abstractButton.revalidate();
        abstractButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, abstractButton.getPreferredSize().height));
        this.components.add(this.buttons.add(abstractButton));
        this.components.add(this.buttons.add(Box.createRigidArea(new Dimension(0, 5))));
    }

    public void resetAllSelections() {
        if (this.items != null) {
            for (AbstractButton abstractButton : this.items) {
                if (!(abstractButton instanceof JCheckBox)) continue;
                JCheckBox jCheckBox = (JCheckBox)abstractButton;
                jCheckBox.setSelected(false);
            }
        }
        if (this.buttonGroup != null) {
            this.buttonGroup.clearSelection();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }
}

