/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyph.GlyphList;
import g2d.glyphviewer.GlyphView;
import g2d.glyphviewer.TabInfo;
import g2d.glyphviewer.TabMenu;
import g2d.graphviewer.Textual;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;

public class SEPanel
extends JTabbedPane
implements Textual,
ChangeListener {
    private static final String INFO_TAB = "Info";
    private static final String MENU_TAB = "Menu";
    private TabInfo tabInfo;
    private TabMenu tabMenu;
    private HashSet<ChangeListener> listeners = new HashSet();

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public SEPanel(GlyphView glyphView) {
        this.setTabPlacement(4);
        this.addChangeListener(this);
    }

    @Override
    public void addTab(String string, Component component) {
        this._addChangeListener(component);
        super.addTab(string, component);
    }

    @Override
    public void addTab(String string, Icon icon, Component component) {
        this._addChangeListener(component);
        super.addTab(string, icon, component);
    }

    @Override
    public void addTab(String string, Icon icon, Component component, String string2) {
        this._addChangeListener(component);
        super.addTab(string, icon, component, string2);
    }

    @Override
    public void remove(Component component) {
        this._removeChangeListener(component);
        super.remove(component);
    }

    @Override
    public void remove(int n) {
        Component component = this.getTabComponentAt(n);
        this._removeChangeListener(component);
        super.remove(n);
    }

    @Override
    public void removeAll() {
        this.listeners.clear();
    }

    private void _addChangeListener(Component component) {
        if (component instanceof ChangeListener) {
            this.listeners.add((ChangeListener)((Object)component));
        }
    }

    private void _removeChangeListener(Component component) {
        if (component instanceof ChangeListener) {
            this.listeners.remove((ChangeListener)((Object)component));
        }
    }

    public void addTabInfo() {
        Font font = UIManager.getFont("Button.font").deriveFont(10.0f);
        this.tabInfo = new TabInfo(font);
        this.addTab(INFO_TAB, this.tabInfo);
    }

    public TabInfo getTabInfo() {
        return this.tabInfo;
    }

    public void addTabMenu() {
        this.tabMenu = new TabMenu();
        this.addTab(MENU_TAB, this.tabMenu);
    }

    public TabMenu getTabMenu() {
        return this.tabMenu;
    }

    public void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.tabInfo.setHyperlinkListener(hyperlinkListener);
    }

    public void clearText() {
        int n;
        if (this.tabInfo != null && (n = this.getSelectedIndex()) == this.indexOfTab(INFO_TAB)) {
            this.displayText("", "");
        }
    }

    @Override
    public void displayText(String string, String string2) {
        if (this.tabInfo != null) {
            this.tabInfo.displayText(string, string2);
            int n = this.indexOfTab(INFO_TAB);
            if (n != -1) {
                this.setEnabledAt(n, true);
                this.setSelectedIndex(n);
            }
        }
    }

    public void clearMenu() {
        int n = this.getSelectedIndex();
        if (n == this.indexOfTab(MENU_TAB)) {
            // empty if block
        }
    }

    public void displayMenu(String string, List<AbstractButton> list) {
        this.displayMenu(string, list, true);
    }

    public void displayMenu(String string, List<AbstractButton> list, boolean bl) {
        this.tabMenu.displayMenu(string, list, null, bl);
        int n = this.indexOfTab(MENU_TAB);
        if (n != -1) {
            this.setEnabledAt(n, true);
            this.setSelectedIndex(n);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof GlyphList) {
            Iterator<ChangeListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().stateChanged(changeEvent);
            }
        }
    }
}

