/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import g2d.swing.ZoomListener;
import g2d.swing.Zoomer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class GlyphPanel
extends JPanel
implements Zoomer,
ChangeListener,
MouseInputListener,
MouseWheelListener {
    public static boolean debugMouseEvents = false;
    protected GlyphList glyphs = null;
    protected Dimension glyphsSize = new Dimension();
    protected Set<ZoomListener> zoomListeners = new HashSet<ZoomListener>();
    protected AffineTransform zoomTransform = new AffineTransform();
    protected Point lastPoint = null;

    public GlyphPanel() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.checkSize();
    }

    public GlyphList getGlyphs() {
        return this.glyphs;
    }

    public void resetGlyphs() {
        this.checkSize();
    }

    public void setGlyphs(GlyphList glyphList) {
        this.glyphs = glyphList;
        this.checkSize();
    }

    public Dimension getGlyphSize() {
        return this.glyphsSize;
    }

    protected void checkSize() {
        if (this.glyphs != null) {
            int n = (int)this.glyphs.getWidth();
            int n2 = (int)this.glyphs.getHeight();
            this.glyphsSize = new Dimension(n, n2);
            if (this.getZoomScale() != 1.0) {
                Shape shape = this.zoomTransform.createTransformedShape(new Rectangle(this.glyphsSize));
                this.glyphsSize = shape.getBounds().getSize();
            }
        } else {
            this.glyphsSize = new Dimension();
        }
        this.setPreferredSize(this.glyphsSize);
        this.revalidate();
    }

    public boolean isEmpty() {
        return this.glyphs == null || this.glyphs.length() == 0;
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.remove(zoomListener);
    }

    protected void notifyZoomListeners() {
        for (ZoomListener zoomListener : this.zoomListeners) {
            zoomListener.zoomChanged(this.getZoomScale());
        }
    }

    public double getZoomScale() {
        return this.zoomTransform.getScaleX();
    }

    protected AffineTransform getInverseZoom() {
        return AffineTransform.getScaleInstance(1.0 / this.getZoomScale(), 1.0 / this.getZoomScale());
    }

    @Override
    public void zoom(double d) {
        if (this.glyphs != null) {
            double d2 = this.zoomTransform.getScaleX() * d;
            if (d2 <= 0.001 || d2 >= 1000.0) {
                return;
            }
            this.zoomTransform.scale(d, d);
            Container container = this.getParent();
            if (container instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                Point2D point2D = AffineTransform.getScaleInstance(d, d).transform(jViewport.getViewPosition(), null);
                jViewport.setViewPosition(new Point((int)point2D.getX(), (int)point2D.getY()));
            }
            this.checkSize();
            this.repaint();
            this.notifyZoomListeners();
        }
    }

    public void zoomToFit(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        if (!new Dimension().equals(this.glyphsSize)) {
            double d = (double)dimension.width / (double)this.glyphsSize.width;
            double d2 = (double)dimension.height / (double)this.glyphsSize.height;
            this.zoom(d > d2 ? d2 : d);
        }
    }

    @Override
    public void zoomToFit() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            this.zoomToFit(jViewport.getExtentSize());
        }
    }

    @Override
    public void zoomToOriginal() {
        this.zoomTransform.setToIdentity();
        this.zoom(1.0);
    }

    public void centerOn(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.getZoomScale() != 1.0) {
                rectangle2D = this.zoomTransform.createTransformedShape(rectangle).getBounds2D();
            }
            Dimension dimension = jViewport.getExtentSize();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
            Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() + dimension.getWidth() / 2.0, ((Point2D)double_).getY() + dimension.getHeight() / 2.0);
            rectangle2D.setFrameFromCenter(double_, double_2);
            if (!jViewport.getViewRect().contains(rectangle2D.getBounds())) {
                this.scrollRectToVisible(rectangle2D.getBounds());
                this.repaint();
            }
        }
    }

    public JFrame getFrame() {
        Window window = SwingUtilities.getWindowAncestor(this);
        JFrame jFrame = null;
        if (window instanceof JFrame) {
            jFrame = (JFrame)window;
        }
        return jFrame;
    }

    public boolean isGlyphishVisible(Glyphish glyphish) {
        if (glyphish == null) {
            return false;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle2D rectangle2D = glyphish.getBounds();
            if (this.getZoomScale() != 1.0) {
                rectangle2D = this.zoomTransform.createTransformedShape(rectangle2D).getBounds2D();
            }
            return jViewport.getViewRect().contains(rectangle2D);
        }
        return false;
    }

    public Point transformFromView(Point point) {
        if (this.getZoomScale() != 1.0) {
            Point2D point2D = this.getInverseZoom().transform(point, null);
            point.setLocation(point2D.getX(), point2D.getY());
        }
        return point;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.glyphs != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.getZoomScale() != 1.0) {
                graphics2D.transform(this.zoomTransform);
            }
            this.glyphs.paint(graphics2D);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d = 0.2;
        this.zoom(Math.abs(1.0 + (double)mouseWheelEvent.getWheelRotation() * d));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && this.glyphs != null && mouseEvent.getClickCount() > 0) {
            Point point = this.transformFromView(mouseEvent.getPoint());
            Glyphish glyphish = this.glyphs.getGlyphThing(point);
            if (!mouseEvent.isShiftDown()) {
                this.mouseClicked(mouseEvent, glyphish, point);
            }
            if (glyphish != null && mouseEvent.getClickCount() < 2) {
                glyphish.mouseClicked(mouseEvent);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.lastPoint = this.glyphs != null && this.glyphs.getGlyphThing(point) == null ? point : null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastPoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastPoint != null && this.glyphs != null && this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Point point = mouseEvent.getPoint();
            if (point != null) {
                Point point2 = jViewport.getViewPosition();
                point2.x -= point.x - this.lastPoint.x;
                point2.y -= point.y - this.lastPoint.y;
                jViewport.setViewPosition(point2);
            }
            this.lastPoint = point;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent, Glyphish glyphish, Point point) {
        if (debugMouseEvents) {
            System.err.println("GlyphPanel.mouseClicked: item = " + glyphish);
        }
        if (glyphish != null) {
            glyphish.mouseClicked(mouseEvent);
        } else if (this.glyphs != null) {
            if (debugMouseEvents && glyphish == null) {
                System.err.println("Warning: from GlyphPanel.mouseClicked - no glyphish thing found");
            }
            this.glyphs.mouseClicked(mouseEvent);
        } else if (debugMouseEvents && glyphish == null) {
            System.err.println("Warning: no glyphs");
        }
    }
}

