/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Glyphish
extends Attributable
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final boolean DEBUG = false;
    private Closure mouseClickedAction;
    private Closure mouseDraggedAction;
    private Closure mouseEnteredAction;
    private Closure mouseExitedAction;
    private Closure mouseMovedAction;
    private Closure mousePressedAction;
    private Closure mouseReleasedAction;
    private Closure keyPressedAction;
    private Closure keyReleasedAction;
    private Closure keyTypedAction;

    public abstract void paint(Graphics2D var1);

    public abstract void transform(AffineTransform var1);

    public abstract boolean inside(Point2D var1);

    public abstract boolean intersects(Rectangle2D var1);

    public abstract Rectangle2D getBounds();

    public Glyphish() {
    }

    public Glyphish(Glyphish glyphish) {
        super(glyphish);
        this.mouseClickedAction = glyphish.mouseClickedAction;
        this.mouseDraggedAction = glyphish.mouseDraggedAction;
        this.mouseEnteredAction = glyphish.mouseEnteredAction;
        this.mouseExitedAction = glyphish.mouseExitedAction;
        this.mouseMovedAction = glyphish.mouseMovedAction;
        this.mousePressedAction = glyphish.mousePressedAction;
        this.mouseReleasedAction = glyphish.mouseReleasedAction;
        this.keyPressedAction = glyphish.keyPressedAction;
        this.keyReleasedAction = glyphish.keyReleasedAction;
        this.keyTypedAction = glyphish.keyTypedAction;
    }

    public void translate(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        this.transform(affineTransform);
    }

    public void scale(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        this.transform(affineTransform);
    }

    public void shear(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getShearInstance(d, d2);
        this.transform(affineTransform);
    }

    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
        this.transform(affineTransform);
    }

    public void rotate(double d) {
        this.rotate(d, this.getBounds().getCenterX(), this.getBounds().getCenterY());
    }

    public void unsetMouseAction(int n) {
        switch (n) {
            case 500: {
                this.mouseClickedAction = null;
                return;
            }
            case 506: {
                this.mouseDraggedAction = null;
                return;
            }
            case 504: {
                this.mouseEnteredAction = null;
                return;
            }
            case 505: {
                this.mouseExitedAction = null;
                return;
            }
            case 503: {
                this.mouseMovedAction = null;
                return;
            }
            case 501: {
                this.mousePressedAction = null;
                return;
            }
            case 502: {
                this.mouseReleasedAction = null;
                return;
            }
        }
        IO.err.println("Glyphish.unsetMouseAction: unrecognized type -- " + n);
    }

    public void setMouseAction(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("Glyphish.setMouseAction: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 500: {
                    this.mouseClickedAction = closure;
                    return;
                }
                case 506: {
                    this.mouseDraggedAction = closure;
                    return;
                }
                case 504: {
                    this.mouseEnteredAction = closure;
                    return;
                }
                case 505: {
                    this.mouseExitedAction = closure;
                    return;
                }
                case 503: {
                    this.mouseMovedAction = closure;
                    return;
                }
                case 501: {
                    this.mousePressedAction = closure;
                    return;
                }
                case 502: {
                    this.mouseReleasedAction = closure;
                    return;
                }
            }
            IO.err.println("Glyphish.setMouseAction: unrecognized type -- " + n);
        }
    }

    private void takeAction(Closure closure, AWTEvent aWTEvent) {
        if (closure != null) {
            closure.applyClosure(this, aWTEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.takeAction(this.mouseClickedAction, mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.takeAction(this.mouseDraggedAction, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.takeAction(this.mouseEnteredAction, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.takeAction(this.mouseExitedAction, mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.takeAction(this.mouseMovedAction, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.takeAction(this.mousePressedAction, mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.takeAction(this.mouseReleasedAction, mouseEvent);
    }

    public void setKeyAction(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("Glyphish.setKeyAction: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 401: {
                    this.keyPressedAction = closure;
                    return;
                }
                case 402: {
                    this.keyReleasedAction = closure;
                    return;
                }
                case 400: {
                    this.keyTypedAction = closure;
                    return;
                }
            }
            IO.err.println("Glyphish.setKeyAction: unrecognized type -- " + n);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.takeAction(this.keyPressedAction, keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.takeAction(this.keyReleasedAction, keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.takeAction(this.keyTypedAction, keyEvent);
    }
}

