/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.BufferedGlyphList;
import g2d.glyph.Glyph;
import g2d.glyph.Glyphish;
import g2d.glyph.ImageGlyph;
import g2d.glyph.TextGlyph;
import g2d.graph.IOPEdge;
import g2d.graph.IOPNode;
import g2d.graph.Spline;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class GlyphList
extends Glyphish {
    public static boolean debug = false;
    public static boolean verbose = true;
    protected double width;
    protected double height;
    protected final List<Glyphish> glyphishThings = Collections.synchronizedList(new ArrayList());

    public GlyphList() {
    }

    public GlyphList(GlyphList glyphList) {
        super(glyphList);
        ListIterator<Glyphish> listIterator = glyphList.glyphishThings.listIterator();
        while (listIterator.hasNext()) {
            Glyphish glyphish = listIterator.next();
            if (glyphish instanceof Spline) {
                this.glyphishThings.add(new Spline((Spline)glyphish));
                continue;
            }
            if (glyphish instanceof GlyphList) {
                this.glyphishThings.add(new GlyphList((GlyphList)glyphish));
                continue;
            }
            if (glyphish instanceof TextGlyph) {
                this.glyphishThings.add(new TextGlyph((TextGlyph)glyphish));
                continue;
            }
            if (glyphish instanceof ImageGlyph) {
                this.glyphishThings.add(new ImageGlyph((ImageGlyph)glyphish));
                continue;
            }
            if (glyphish instanceof Glyph) {
                this.glyphishThings.add(new Glyph((Glyph)glyphish));
                continue;
            }
            throw new RuntimeException("Forgot a glyph class: " + glyphish.getClass());
        }
    }

    public GlyphList(ArrayList<Glyphish> arrayList) {
        for (Glyphish glyphish : arrayList) {
            this.glyphishThings.add(glyphish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyphish get(int n) {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            if (this.glyphishThings.size() > 0) {
                return this.glyphishThings.get(n);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyphish getGlyphThing(Point2D point2D) {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator(this.glyphishThings.size());
            while (listIterator.hasPrevious()) {
                Glyphish glyphish = listIterator.previous();
                if (!glyphish.inside(point2D)) continue;
                return glyphish;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyphish[] getGlyphishInArray() {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            return this.glyphishThings.toArray(new Glyphish[this.glyphishThings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Glyphish> getGlyphishInCollection() {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            return new ArrayList<Glyphish>(this.glyphishThings);
        }
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = null;
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator();
            while (listIterator.hasNext()) {
                Glyphish glyphish = listIterator.next();
                if (rectangle2D == null) {
                    rectangle2D = glyphish.getBounds();
                    continue;
                }
                Rectangle2D rectangle2D2 = glyphish.getBounds();
                if (rectangle2D2 == null) continue;
                rectangle2D.add(rectangle2D2);
            }
        }
        return rectangle2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inside(Point2D point2D) {
        boolean bl = false;
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator(this.glyphishThings.size());
            while (listIterator.hasPrevious()) {
                if (!listIterator.previous().inside(point2D)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        boolean bl = false;
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator(this.glyphishThings.size());
            while (listIterator.hasPrevious()) {
                Glyphish glyphish = listIterator.previous();
                if (!glyphish.intersects(rectangle2D)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Glyphish glyphish) {
        if (glyphish != null) {
            List<Glyphish> list = this.glyphishThings;
            synchronized (list) {
                this.glyphishThings.add(glyphish);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Glyphish glyphish) {
        if (glyphish != null) {
            List<Glyphish> list = this.glyphishThings;
            synchronized (list) {
                this.glyphishThings.add(n, glyphish);
            }
        }
    }

    public void add(Glyphish glyphish, AffineTransform affineTransform) {
        if (glyphish != null) {
            glyphish.transform(affineTransform);
            this.add(glyphish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            this.glyphishThings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Glyphish glyphish) {
        if (glyphish != null) {
            List<Glyphish> list = this.glyphishThings;
            synchronized (list) {
                this.glyphishThings.removeAll(Collections.singleton(glyphish));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Glyphish glyphish) {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            return this.glyphishThings.contains(glyphish);
        }
    }

    public ListIterator<Glyphish> getListIterator() {
        return this.glyphishThings.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            return this.glyphishThings.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D graphics2D) {
        boolean bl = this instanceof BufferedGlyphList;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (verbose && bl) {
            System.err.println("GlyphList painting: " + this.getClass());
            System.err.println("g2d.getClipBounds() = " + rectangle);
        }
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator();
            if (rectangle == null) {
                while (listIterator.hasNext()) {
                    listIterator.next().paint(graphics2D);
                }
            } else {
                while (listIterator.hasNext()) {
                    Glyphish glyphish = listIterator.next();
                    if (!glyphish.intersects(rectangle)) continue;
                    ++n;
                    glyphish.paint(graphics2D);
                    if (glyphish instanceof IOPNode) {
                        ++n3;
                    }
                    if (!(glyphish instanceof IOPEdge)) continue;
                    ++n2;
                }
                if (verbose && bl) {
                    System.err.format("GlyphList.paint painted %d glyphish things: %d nodes, %d edges out of %d glyphs\n", n, n3, n2, this.glyphishThings.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(AffineTransform affineTransform) {
        List<Glyphish> list = this.glyphishThings;
        synchronized (list) {
            ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator();
            while (listIterator.hasNext()) {
                listIterator.next().transform(affineTransform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "GlyphList:";
        if (debug) {
            List<Glyphish> list = this.glyphishThings;
            synchronized (list) {
                int n = 0;
                ListIterator<Glyphish> listIterator = this.glyphishThings.listIterator();
                while (listIterator.hasNext()) {
                    string = string + "\n\tglyphList[" + n++ + "] = " + listIterator.next();
                }
            }
        } else {
            string = string + this.hashCode();
        }
        return string;
    }

    public void dump() {
        System.err.println(this.toString());
    }
}

