/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.Glyphish;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Glyph
extends Glyphish {
    public static boolean debug = false;
    public static Color HIGHLIGHT = Color.RED;
    public static int HIGHLIGHT_FACTOR = 2;
    private Stroke stroke = new BasicStroke(1.25f);
    private Stroke hstroke = new BasicStroke((float)HIGHLIGHT_FACTOR * 1.25f);
    private Color border;
    private Color fill;
    private Shape shape;
    private boolean highlighted = false;
    protected final AffineTransform _transform = new AffineTransform();

    public Glyph() {
    }

    public Glyph(Shape shape) {
        this.setGlyph(shape, null, null);
    }

    public Glyph(Color color, Color color2) {
        this.setGlyph(null, color, color2);
    }

    public Glyph(Shape shape, Color color, Color color2) {
        this.setGlyph(shape, color, color2);
    }

    public void setGlyph(Shape shape, Color color, Color color2) {
        this.shape = shape;
        this.border = color;
        this.fill = color2;
    }

    public Glyph(Glyph glyph) {
        this.setGlyph(glyph.shape, glyph.border, glyph.fill);
    }

    public boolean getHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public Color getFill() {
        return this.fill;
    }

    public void setFill(Color color) {
        this.fill = color;
    }

    public Color getBorder() {
        return this.border;
    }

    public void setBorder(Color color) {
        this.border = color;
    }

    public void setColor(Color color) {
        this.setFill(color);
        this.setBorder(color);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public boolean inside(Point2D point2D) {
        if (this.shape == null) {
            return false;
        }
        return this.shape.contains(point2D);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return true;
        }
        if (this.shape == null) {
            return false;
        }
        return this.shape.intersects(rectangle2D);
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.shape != null) {
            return this.shape.getBounds2D();
        }
        return null;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        try {
            if (this.stroke != null) {
                if (this.fill != null && this.shape != null) {
                    graphics2D.setColor(this.fill);
                    graphics2D.fill(this.shape);
                }
                if (this.border != null && this.shape != null) {
                    if (this.highlighted) {
                        graphics2D.setColor(HIGHLIGHT);
                        graphics2D.setStroke(this.hstroke);
                        graphics2D.draw(this.shape);
                    } else {
                        graphics2D.setColor(this.border);
                        graphics2D.setStroke(this.stroke);
                        graphics2D.draw(this.shape);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this._transform.preConcatenate(affineTransform);
        this.shape = affineTransform.createTransformedShape(this.shape);
    }

    public String toString() {
        String string = super.toString();
        if (debug) {
            Rectangle2D rectangle2D = this.getBounds();
            string = string + " " + rectangle2D;
        }
        return string;
    }
}

