/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BufferedGlyphList
extends GlyphList {
    public static final boolean buffered = false;
    public int paintCount = 0;
    public static boolean paintDebug = true;
    public static int NODE_THRESHOLD = 500;
    public static int EDGE_THRESHOLD = 1500;
    public static int THRESHOLD = NODE_THRESHOLD + EDGE_THRESHOLD;
    public static int LARGE = 1000;
    public boolean displayable = true;
    protected int version = 1;
    private int image_version = 0;
    private BufferedImage image = null;
    private final HashSet<ChangeListener> listeners = new HashSet();
    private final int padding = 2;
    private BufferedImage cached_image = null;
    private double cached_scale = 0.0;

    public void setDisplayable(int n, int n2) {
        this.displayable = n < NODE_THRESHOLD && n2 < EDGE_THRESHOLD;
    }

    public void setDisplayable() {
        this.displayable = this.length() < THRESHOLD;
    }

    public void setDisplayable(boolean bl) {
        this.displayable = bl;
    }

    public boolean isLarge() {
        return this.length() > LARGE;
    }

    public BufferedGlyphList() {
    }

    public BufferedGlyphList(BufferedGlyphList bufferedGlyphList) {
        super(bufferedGlyphList);
        this.listeners.addAll(bufferedGlyphList.listeners);
        this.fireChange();
    }

    @Override
    public void add(Glyphish glyphish) {
        super.add(glyphish);
        if (glyphish != null) {
            this.fireChange();
        }
    }

    @Override
    public void add(int n, Glyphish glyphish) {
        super.add(n, glyphish);
        if (glyphish != null) {
            this.fireChange();
        }
    }

    @Override
    public void add(Glyphish glyphish, AffineTransform affineTransform) {
        super.add(glyphish, affineTransform);
        if (glyphish != null) {
            this.fireChange();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.fireChange();
    }

    @Override
    public void remove(Glyphish glyphish) {
        super.remove(glyphish);
        this.fireChange();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        long l = System.nanoTime();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (paintDebug) {
            System.err.format("BufferedGlyphList.paint commencing: clip = " + rectangle + "\n", new Object[0]);
        }
        if (paintDebug) {
            System.err.println("BufferedGlyphList.paint iterating over glyphs");
        }
        if (this.displayable) {
            super.paint(graphics2D);
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        if (paintDebug) {
            System.err.format("BufferedGlyphList.paint finished painting in %d milliseconds\n", l3 / 10000000L);
        }
    }

    public BufferedImage getBufferedImage() {
        double d = 1.0;
        Rectangle rectangle = new Rectangle(0, 0, (int)Math.ceil(this.getWidth()), (int)Math.ceil(this.getHeight()));
        Rectangle rectangle2 = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        if (!rectangle2.contains(rectangle)) {
            double d2;
            double d3;
            d = rectangle2.width >= rectangle.width ? (double)rectangle2.height / (double)rectangle.height : (rectangle2.height >= rectangle.height ? (double)rectangle2.width / (double)rectangle.width : ((d3 = (double)rectangle.width / (double)rectangle.height) > (d2 = (double)rectangle2.width / (double)rectangle2.height) ? (double)rectangle2.width / (double)rectangle.width : (double)rectangle2.height / (double)rectangle.height));
        }
        return this.getBufferedImage(d);
    }

    public BufferedImage getBufferedImage(double d) {
        BufferedImage bufferedImage = null;
        long l = System.nanoTime();
        if (paintDebug) {
            System.err.format("BufferedGlyphList.getBufferedImage(%f) width = %d height = %d\n", d, (int)this.width, (int)this.height);
        }
        if (this.width == 0.0 || this.height == 0.0) {
            return null;
        }
        if (this.isLarge() && d == this.cached_scale && this.cached_image != null) {
            if (paintDebug) {
                System.err.println("BufferedGlyphList.getBufferedImage(%f) using cached_image");
            }
            bufferedImage = this.cached_image;
        } else {
            bufferedImage = new BufferedImage((int)Math.ceil(d * this.width) + 2, (int)Math.ceil(d * this.height) + 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.scale(d, d);
            if (this.displayable) {
                super.paint(graphics2D);
            }
            graphics2D.dispose();
            this.cached_image = bufferedImage;
            this.cached_scale = d;
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        if (paintDebug) {
            System.err.format("BufferedGlyphList.getBufferedImage(%f) finished in %d milliseconds\n", d, l3 / 10000000L);
        }
        return bufferedImage;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChange(ChangeEvent changeEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void fireChange() {
        if (this.version == Integer.MAX_VALUE) {
            this.image_version = 0;
            this.version = 1;
        } else {
            ++this.version;
        }
        assert (this.image_version < this.version);
        this.fireChange(new ChangeEvent(this));
    }
}

