/*
 * Decompiled with CFR 0.152.
 */
package g2d.console;

import g2d.console.InputTextArea;
import g2d.console.MenuBar;
import g2d.console.SearchDialog;
import g2d.jlambda.Interpreter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.pf.joi.Inspector;

public class Console
extends JPanel {
    private static JFrame consoleFrame = null;
    public static final Preferences preferences = Preferences.userNodeForPackage(Console.class);
    public static final g2d.util.Preferences g2d_preferences = new g2d.util.Preferences(preferences);
    private static final boolean debug = false;
    protected static final String PREFIX = "Status: ";
    protected final JFrame parent;
    protected final InputTextArea input;
    protected final JEditorPane output;
    protected final JLabel status;
    protected final JComboBox<String> namespaceChooser;
    protected final String ilk;
    protected final File cwd;

    protected static Runnable launcher(final String string, final String string2, final File file) {
        return new Runnable(){

            @Override
            public void run() {
                consoleFrame = new JFrame(string);
                consoleFrame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                consoleFrame.setDefaultCloseOperation(1);
                new Console(consoleFrame, string2, file);
                consoleFrame.pack();
                consoleFrame.setVisible(true);
            }
        };
    }

    protected static Runnable launcher(String string, String string2) {
        return Console.launcher(string, string2, null);
    }

    public static final void launchInvokeAndWait() {
        try {
            SwingUtilities.invokeAndWait(Console.launcher("JLambda Console", "default"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final void launch(String string) {
        if (consoleFrame == null) {
            new Thread(Console.launcher("JLambda Console", string)).start();
        } else {
            consoleFrame.setVisible(true);
        }
    }

    public static final void launch(String string, String string2) {
        Console.launch(string, string2, null);
    }

    public static final void launch(String string, String string2, File file) {
        if (consoleFrame == null) {
            new Thread(Console.launcher(string, string2, file)).start();
        } else {
            consoleFrame.setVisible(true);
        }
    }

    public static final void launch() {
        Console.launch("default");
    }

    public static void main(String[] stringArray) {
        Console.launchInvokeAndWait();
    }

    public Console(JFrame jFrame) {
        this(jFrame, "default", null);
    }

    public Console(JFrame jFrame, String string) {
        this(jFrame, string, null);
    }

    public Console(JFrame jFrame, String string, File file) {
        super(new BorderLayout());
        this.parent = jFrame;
        this.ilk = "jconsole_" + string;
        this.cwd = file;
        g2d_preferences.manageJFrame(this.parent, this.ilk);
        this.input = new InputTextArea(this);
        this.output = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.input);
        JScrollPane jScrollPane2 = new JScrollPane(this.output);
        this.status = new JLabel();
        this.output.setEditable(false);
        MenuBar menuBar = new MenuBar(this);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Namespace: ");
        this.namespaceChooser = new JComboBox<String>(Interpreter.getNamespaces());
        jPanel.add(jLabel);
        jPanel.add(this.namespaceChooser);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel3);
        g2d_preferences.manageJSplitPane(jSplitPane, this.ilk);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.status, "North");
        this.setOpaque(true);
        jFrame.setContentPane(this);
        jFrame.setJMenuBar(menuBar);
        this.checkAndLoadFile();
    }

    private void checkAndLoadFile() {
        File file;
        if (this.cwd != null && (file = new File(this.cwd, "console.lsp")).exists()) {
            this.loadFile(file);
            return;
        }
        file = g2d_preferences.getChosenFile(this.ilk);
        if (file != null && file.exists()) {
            this.loadFile(file);
        }
    }

    protected void loadFile() {
        this.input.loadFile();
    }

    protected void reloadFile() {
        this.input.reloadFile();
    }

    protected void saveFile() {
        this.input.saveFile();
    }

    protected void saveFileAs() {
        this.input.saveFileAs();
    }

    protected void search() {
        this.search(new SearchDialog(this, this.parent));
    }

    protected void exit() {
        this.parent.setVisible(false);
    }

    protected void cut() {
        this.input.cut();
    }

    protected void copy() {
        this.input.copy();
    }

    protected void paste() {
        this.input.paste();
    }

    protected void viewUIDs() {
        Interpreter interpreter = this.getInterpreter();
        String string = interpreter.stringOfUIDs();
        this.appendString2Output(string);
    }

    protected void viewDefinitions() {
        Interpreter interpreter = this.getInterpreter();
        String string = interpreter.stringOfDefinitions();
        this.appendString2Output(string);
    }

    private void appendString2Output(String string) {
        try {
            Document document = this.output.getDocument();
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void search(SearchDialog searchDialog) {
        searchDialog.setVisible(true);
    }

    protected void search(String string, boolean bl, boolean bl2) {
        this.input.search(string, bl, bl2);
    }

    protected String text4Evaluation(Command command) {
        String string = "";
        switch (command) {
            case BUFFER: {
                string = this.input.getText();
                break;
            }
            case SELECTED: {
                string = this.input.getSelectedText();
                break;
            }
            case LINE: {
                string = this.input.getLine();
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    protected void appendResult(String string) {
        String string2 = this.output.getText();
        string2 = string2 + "\n" + string;
        this.output.setText(string2);
    }

    private Interpreter getInterpreter() {
        String string = (String)this.namespaceChooser.getSelectedItem();
        return Interpreter.getInterpreter(string);
    }

    protected void evaluate(Command command) {
        String string = this.text4Evaluation(command);
        String string2 = "";
        Interpreter interpreter = this.getInterpreter();
        try {
            Object object = interpreter.evaluateText(string);
            string2 = "" + object;
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        this.appendResult(string2);
    }

    protected void inspect(Command command) {
        String string = this.text4Evaluation(command);
        String string2 = "";
        if (string != null) {
            try {
                Interpreter interpreter = this.getInterpreter();
                Object object = interpreter.evaluateText(string);
                Inspector.inspect(object);
                string2 = "Inspector launched for: " + object;
            }
            catch (Exception exception) {
                string2 = exception.getMessage();
            }
        }
        this.appendResult(string2);
    }

    protected void setStatus(String string) {
        this.status.setText(PREFIX + string);
    }

    protected void loadFile(String string) {
        this.loadFile(new File(string));
    }

    protected void loadFile(File file) {
        try {
            String string = this.readFile(file);
            if (string != null) {
                this.input.setText(string);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void returnResult(String string) {
        String string2 = this.output.getText();
        string2 = string2 + "\n" + string;
        this.output.setText(string2);
    }

    String readFile(String string) throws IOException {
        return this.readFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readFile(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        String string = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                stringBuilder.append(scanner.nextLine() + string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }

    static {
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JLambda Console");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("static g2d.console.Console block: " + exception);
            }
        }
    }

    public static enum Command {
        BUFFER,
        SELECTED,
        LINE;

    }
}

