/*
 * Decompiled with CFR 0.152.
 */
package g2d.closure;

import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ClosureWindowListener
extends Attributable
implements WindowListener {
    private Closure windowActivatedAction;
    private Closure windowClosedAction;
    private Closure windowClosingAction;
    private Closure windowDeactivatedAction;
    private Closure windowDeiconifiedAction;
    private Closure windowIconifiedAction;
    private Closure windowOpenedAction;

    public void setActionClosure(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureWindowListener.setActionClosure: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 205: {
                    this.windowActivatedAction = closure;
                    return;
                }
                case 202: {
                    this.windowClosedAction = closure;
                    return;
                }
                case 201: {
                    this.windowClosingAction = closure;
                    return;
                }
                case 206: {
                    this.windowDeactivatedAction = closure;
                    return;
                }
                case 204: {
                    this.windowDeiconifiedAction = closure;
                    return;
                }
                case 203: {
                    this.windowIconifiedAction = closure;
                    return;
                }
                case 200: {
                    this.windowOpenedAction = closure;
                    return;
                }
            }
            IO.err.println("ClosureWindowListener.setAction: unrecognized type -- " + n);
        }
    }

    private void takeAction(Closure closure, WindowEvent windowEvent) {
        if (closure != null) {
            closure.applyClosure(this, windowEvent);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.takeAction(this.windowActivatedAction, windowEvent);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.takeAction(this.windowClosedAction, windowEvent);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.takeAction(this.windowClosingAction, windowEvent);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.takeAction(this.windowDeactivatedAction, windowEvent);
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.takeAction(this.windowDeiconifiedAction, windowEvent);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.takeAction(this.windowIconifiedAction, windowEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.takeAction(this.windowOpenedAction, windowEvent);
    }
}

