/*
 * Decompiled with CFR 0.152.
 */
package g2d.closure;

import g2d.glyph.Glyphish;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.util.IO;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ClosureGlyph
extends Glyphish {
    private Closure paintClosure;
    private Closure insideClosure;
    private Closure intersectsClosure;
    private Closure transformClosure;
    private Closure boundsClosure;

    @Override
    public boolean inside(Point2D point2D) {
        if (this.insideClosure != null) {
            Object object = this.insideClosure.applyClosure(this, point2D);
            if ((object = PrimitiveData.unwrap(object)) instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (this.intersectsClosure != null) {
            Object object = this.intersectsClosure.applyClosure(this, rectangle2D);
            if ((object = PrimitiveData.unwrap(object)) instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.paintClosure != null) {
            this.paintClosure.applyClosure(this, graphics2D);
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.transformClosure != null) {
            this.transformClosure.applyClosure(this, affineTransform);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        Object object = null;
        if (this.boundsClosure != null) {
            object = this.boundsClosure.applyClosure(this);
        }
        if (object instanceof Rectangle2D) {
            return (Rectangle2D)object;
        }
        return null;
    }

    public void setPaintClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureGlyph.setPaintClosure: closure arity not 2 -- " + closure);
        }
        this.paintClosure = closure;
    }

    public void setInsideClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureGlyph.setInsideClosure: closure arity not 2 -- " + closure);
        }
        this.insideClosure = closure;
    }

    public void setIntersectsClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureGlyph.setIntersectsClosure: closure arity not 2 -- " + closure);
        }
        this.intersectsClosure = closure;
    }

    public void setTransformClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureGlyph.setTransformClosure: closure arity not 2 -- " + closure);
        }
        this.transformClosure = closure;
    }

    public void setBoundsClosure(Closure closure) {
        if (closure.getArity() != 1) {
            IO.err.println("ClosureGlyph.setBoundsClosure: closure arity not 1 -- " + closure);
        }
        this.boundsClosure = closure;
    }
}

