/*
 * Decompiled with CFR 0.152.
 */
package g2d;

import g2d.FileManager;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.util.ActorMsg;
import java.util.ArrayList;
import java.util.Iterator;

public class Behavior {
    private static final ArrayList<Closure> callbacks = new ArrayList();

    static boolean isSexpression(ActorMsg actorMsg) {
        ActorMsg.Token token = actorMsg.getNextToken();
        if (token == null) {
            return false;
        }
        byte by = token.byteAt(0);
        return by == 40;
    }

    static boolean isFileManagerRequest(ActorMsg.Token token) {
        byte by = token.byteAt(0);
        if (by != 114 && by != 119 && by != 97) {
            return false;
        }
        String string = token.toString();
        return "read".equals(string) || "write".equals(string) || "append".equals(string);
    }

    public static void addCallback(Closure closure) {
        if (Behavior.checkCallback(closure)) {
            callbacks.add(closure);
        }
    }

    public static void removeCallback(Closure closure) {
        callbacks.remove(closure);
    }

    static void handle(ActorMsg actorMsg) {
        ActorMsg.Token token = actorMsg.lastToken;
        boolean bl = false;
        if (token == null) {
            return;
        }
        if (Behavior.isFileManagerRequest(token)) {
            FileManager.handle(actorMsg);
        } else {
            Closure closure;
            String string = actorMsg.getSender();
            String string2 = token.toString();
            String string3 = actorMsg.getBody();
            Iterator<Closure> iterator = callbacks.iterator();
            while (iterator.hasNext() && !(bl = Behavior.reply(closure = iterator.next(), string, string2, string3))) {
            }
            if (!bl) {
                System.err.println("Behavior did not handle the following message: ");
                System.err.println("\tsender = " + string);
                System.err.println("\tverb   = " + string2);
                System.err.println("\tbody   = " + string3);
            }
        }
    }

    private static boolean checkCallback(Closure closure) {
        if (closure == null) {
            System.err.println("checkCallback: callback closure cannot be null");
            return false;
        }
        int n = closure.getArity();
        if (n != 3) {
            System.err.println("checkCallback: callback closure arity not 3 -- " + n);
            return false;
        }
        return true;
    }

    private static boolean reply(Closure closure, String string, String string2, String string3) {
        Object object = closure.applyClosure(string, string2, string3);
        if ((object = PrimitiveData.unwrap(object)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }
}

