/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Editor;
import GUI.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class ToolBar
extends JToolBar {
    private final Editor editor;
    private Registry theRegistry;
    private String selectedActor = null;
    private final JComboBox<Object> choice = new JComboBox();
    protected static final String[] buttonLabels = new String[]{"Buffer", "Selected", "Line"};
    private final JButton[] buttons = new JButton[buttonLabels.length];
    private final ActionListener[] buttonListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolBar.this.editor.sendMessage(0);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolBar.this.editor.sendMessage(1);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolBar.this.editor.sendMessage(2);
        }
    }};

    public ToolBar(Editor editor) {
        this.editor = editor;
        this.initButtons(this.buttons, buttonLabels, this.buttonListeners, this.choice);
        this.setFloatable(false);
    }

    public int getSelectedIndex() {
        return this.theRegistry.getIndex((String)this.choice.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChoice() {
        this.theRegistry = Registry.getRegistry();
        ToolBar._a_("got theRegistry: \n" + this.theRegistry);
        boolean bl = false;
        int n = 1;
        while (!bl) {
            ToolBar._a_("attempt no. " + n + " to initialize choice\n");
            ToolBar toolBar = this;
            synchronized (toolBar) {
                Object object;
                this.choice.removeAllItems();
                try {
                    for (int i = 0; i < this.theRegistry.getLength(); ++i) {
                        object = this.theRegistry.getName(i);
                        this.choice.addItem(object);
                        if (this.selectedActor != null && this.selectedActor.equals(object)) {
                            this.choice.setSelectedItem(object);
                        }
                        ToolBar._a_("added theRegistry[" + i + "] to choice\n");
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    ++n;
                    object = exception.getStackTrace();
                    for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                        Editor.errors.log("stack " + i + ": " + object[i]);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        ToolBar._a_("theRegistry configured\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRegistry(String string) {
        ToolBar._a_("calling updateRegistry(" + string + ")");
        ToolBar toolBar = this;
        synchronized (toolBar) {
            String string2 = (String)this.choice.getSelectedItem();
            if (string != null) {
                string2 = this.selectedActor = string;
            }
            this.choice.removeAllItems();
            this.theRegistry = Registry.getRegistry();
            for (int i = 0; i < this.theRegistry.getLength(); ++i) {
                String string3 = this.theRegistry.getName(i);
                this.choice.addItem(string3);
                if (!string2.equals(string3)) continue;
                this.choice.setSelectedItem(string3);
            }
        }
    }

    private void initButtons(JButton[] jButtonArray, String[] stringArray, ActionListener[] actionListenerArray, JComboBox jComboBox) {
        this.setLayout(new BoxLayout(this, 2));
        JLabel jLabel = new JLabel("      Send:");
        jLabel.setForeground(Color.blue);
        JLabel jLabel2 = new JLabel("      To:");
        jLabel2.setForeground(Color.blue);
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        for (int i = 0; i < stringArray.length; ++i) {
            jButtonArray[i] = new JButton(stringArray[i]);
            jButtonArray[i].addActionListener(actionListenerArray[i]);
            jButtonArray[i].setToolTipText("Send the current " + stringArray[i].toLowerCase() + " to the actor selected ");
            this.add(jButtonArray[i]);
            this.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        this.add(jLabel2);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        jComboBox.setToolTipText("Select the recipient actor");
        this.add(jComboBox);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
    }

    private static void _a_(String string) {
        Editor._a_(string);
    }
}

