/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Editor;
import GUI.RegConnection;

public class Registry {
    private int length;
    private int[] indexes;
    private String[] names;

    protected static Registry getRegistry() {
        try {
            RegConnection regConnection = new RegConnection("Registry.getRegistry()");
            regConnection.writeInt(4);
            int n = regConnection.readInt();
            Registry registry = new Registry(n);
            for (int i = 0; i < n; ++i) {
                registry.setIndex(i, regConnection.readInt());
                registry.setName(i, regConnection.readString());
            }
            regConnection.close();
            return registry;
        }
        catch (Exception exception) {
            Registry._e_(exception);
            return null;
        }
    }

    public Registry(int n) {
        this.length = n;
        this.indexes = new int[this.length];
        this.names = new String[this.length];
    }

    public int getLength() {
        return this.length;
    }

    public int getIndex(int n) {
        return this.indexes[n];
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.length; ++i) {
            if (!string.equals(this.names[i])) continue;
            return this.indexes[i];
        }
        return -1;
    }

    public String getName(int n) {
        return this.names[n];
    }

    public void setIndex(int n, int n2) {
        this.indexes[n] = n2;
    }

    public void setName(int n, String string) {
        this.names[n] = string;
    }

    public String toString() {
        String string = "Registry has " + this.length + " members:\n";
        for (int i = 0; i < this.length; ++i) {
            string = string + "\tregistry[" + this.indexes[i] + "] = " + this.names[i] + "\n";
        }
        return string;
    }

    private static void _a_(String string) {
        Editor._a_(string);
    }

    private static void _e_(String string) {
        Editor._e_(string);
    }

    private static void _e_(Exception exception) {
        Editor._e_(exception);
    }
}

