/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Constants;
import GUI.Editor;
import GUI.RegConnection;
import java.awt.Color;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JTextArea;

public class OutputTextArea
extends JTextArea
implements Runnable {
    private static int reg2InPortNumber;
    private static ServerSocket reg2InSocket;
    private Editor editor;

    public OutputTextArea(Editor editor) {
        super("", 10, 80);
        this.editor = editor;
        this.setBackground(Color.white);
        this.setEditable(false);
    }

    public void initialize() {
        int n = Constants.getFontStyle();
        int n2 = Constants.getFontSize();
        this.setFont(Constants.iopFont(n, n2));
        if (!OutputTextArea.allocateReg2InPort()) {
            OutputTextArea._e_("Couldn't allocate Reg 2 Input ServerSocket");
            System.exit(1);
        }
        if (!OutputTextArea.notifyRegistry(reg2InPortNumber)) {
            OutputTextArea._e_("Failed to notify registry of reg2InPortNumber");
            System.exit(1);
        }
    }

    private static boolean notifyRegistry(int n) {
        try {
            RegConnection regConnection = new RegConnection("OutputTextArea.notifyRegistry()");
            regConnection.writeInt(n);
            regConnection.close();
            return true;
        }
        catch (Exception exception) {
            OutputTextArea._a_("notifyRegistry failed: " + exception);
            return false;
        }
    }

    private static boolean allocateReg2InPort() {
        for (reg2InPortNumber = 8000; reg2InPortNumber < 9000; reg2InPortNumber += 2) {
            try {
                OutputTextArea._a_("Creating ServerSocket on portNo: " + reg2InPortNumber);
                reg2InSocket = new ServerSocket(reg2InPortNumber);
                OutputTextArea._a_("Created ServerSocket OK");
                return true;
            }
            catch (Exception exception) {
                OutputTextArea._a_("allocateReg2InPort failed: " + exception);
                continue;
            }
        }
        reg2InPortNumber = -1;
        OutputTextArea._e_("OutputTextArea.allocateReg2InPort failed (fatal)!");
        return false;
    }

    private int lineStart(int n) {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        int n2 = string.length() - 1;
        if (n > n2) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        while (n > 0) {
            if (string.charAt(n) == '\n') {
                return n + 1;
            }
            --n;
        }
        return n;
    }

    public synchronized void resetViewToEnd() {
        try {
            if (!Editor.calm) {
                int n = this.getDocument().getLength();
                this.setCaretPosition(n);
                this.requestFocusInWindow();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void addText(String string) {
        this.append(string);
        this.resetViewToEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 1024;
        byte[] byArray = new byte[n];
        while (true) {
            try {
                while (true) {
                    int n2;
                    Object object;
                    Socket socket;
                    InputStream inputStream;
                    int n3;
                    if ((n3 = RegConnection.readInt(inputStream = (socket = reg2InSocket.accept()).getInputStream())) < 0) {
                        OutputTextArea._e_("Read of type failed in OutputTextArea");
                        return;
                    }
                    if (n3 != 7 && n3 != 8 && n3 == 9) {
                        this.editor.updateRegistry(null);
                    }
                    if (n3 == 10) {
                        object = null;
                        n2 = inputStream.read(byArray);
                        if (n2 > 0) {
                            object = new String(byArray, 0, n2);
                        }
                        this.editor.updateRegistry((String)object);
                    }
                    do {
                        if ((n2 = inputStream.read(byArray)) <= 0) continue;
                        object = this;
                        synchronized (object) {
                            this.append(new String(byArray, 0, n2));
                        }
                    } while (n2 > 0);
                    inputStream.close();
                    socket.close();
                    this.resetViewToEnd();
                }
            }
            catch (Exception exception) {
                OutputTextArea._a_("run failed: " + exception);
                continue;
            }
            break;
        }
    }

    private static void _a_(String string) {
        Editor._a_(string);
    }

    private static void _e_(String string) {
        Editor._e_(string);
    }
}

