/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Constants;
import GUI.Editor;
import GUI.InitFile;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;

public class InputTextArea
extends JTextArea {
    private String currentFile;
    private String buffer;
    private Editor editor;
    private volatile boolean fresh = true;
    private static boolean doubleclick = true;

    public InputTextArea(Editor editor) {
        this.editor = editor;
    }

    protected static void setDoubleClickEnabled(boolean bl) {
        doubleclick = bl;
    }

    protected void initialize() {
        String string = InitFile.getInitFile();
        if (string != null) {
            this.loadFile(string);
        } else {
            this.setText(Constants.iopWelcome);
            Timer timer = new Timer();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (InputTextArea.this.fresh) {
                        InputTextArea.this.fresh = false;
                        InputTextArea.this.setText(null);
                    }
                }
            };
            timer.schedule(timerTask, 10000L);
        }
        int n = Constants.getFontStyle();
        int n2 = Constants.getFontSize();
        this.setFont(Constants.iopFont(n, n2));
        this.setBackground(Color.white);
        this.setSelectedTextColor(Color.red);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (InputTextArea.this.fresh) {
                    InputTextArea.this.fresh = false;
                    InputTextArea.this.setText(null);
                }
                if (doubleclick && mouseEvent.getClickCount() == 2) {
                    InputTextArea.this.editor.sendMessage(2);
                }
            }
        });
        InputTextArea._a_("MouseListener added\n");
    }

    protected void loadFile() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            InputTextArea._a_("File = " + jFileChooser.getSelectedFile());
            this.loadFile(jFileChooser.getSelectedFile().toString());
            return;
        }
        InputTextArea._a_("Open cancelled");
    }

    protected void loadFile(String string) {
        InputTextArea._a_("Editor loading file = " + string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            this.setText(null);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            bufferedReader.close();
            this.setText(new String(stringBuffer));
            this.setCaretPosition(0);
            this.currentFile = string;
            this.fresh = false;
        }
        catch (IOException iOException) {
            Editor.errors.log(iOException);
        }
    }

    protected void saveFile() {
        this.saveFileAs(this.currentFile);
    }

    protected void saveFileAs() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            InputTextArea._a_("File = " + jFileChooser.getSelectedFile());
            this.saveFileAs(jFileChooser.getSelectedFile().toString());
            return;
        }
        InputTextArea._a_("SaveAs cancelled");
    }

    protected void saveFileAs(String string) {
        PrintWriter printWriter;
        this.fresh = false;
        InputTextArea._a_("Editor saving file = " + string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(string), true);
        }
        catch (IOException iOException) {
            Editor.errors.log(iOException);
            return;
        }
        printWriter.print(this.getText());
        printWriter.close();
        this.editor.addOutputText("Finished  saving " + string + "\n");
    }

    protected void clear() {
        this.fresh = false;
        InputTextArea._a_("Editor clearing");
        this.setText(null);
    }

    protected void search(String string, boolean bl, boolean bl2) {
        this.fresh = false;
        InputTextArea._a_("Editor searching caseSensitive = " + bl + " backwards = " + bl2);
        String string2 = this.getText();
        if (!bl) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        InputTextArea._a_("\tSelection at " + this.getSelectionEnd());
        int n = bl2 ? string2.lastIndexOf(string, this.getSelectionStart() - string.length()) : string2.indexOf(string, this.getSelectionEnd());
        InputTextArea._a_("\tIndex found at " + n);
        if (n == -1) {
            InputTextArea._a_("No such substring-Wrapping around");
            if (bl2) {
                this.select(string2.length() - 1, string2.length() - 1);
            } else {
                this.select(0, 0);
            }
            return;
        }
        InputTextArea._a_("\tSelecting text");
        this.select(n, n + string.length());
        InputTextArea._a_("\tSelection at " + this.getSelectionEnd());
    }

    protected String getLine() {
        int n;
        String string = this.getText();
        int n2 = string.length();
        if (string == null || n2 == 0) {
            return null;
        }
        int n3 = this.getCaretPosition();
        int n4 = -1;
        if (n2 > 0 && n3 == n2) {
            --n3;
        }
        if (string.charAt(n3) == '\n' && n3 > 0) {
            n = n3 - 1;
            n4 = n3;
        } else {
            n = n3;
        }
        while (n >= 0 && string.charAt(n) != '\n') {
            --n;
        }
        if (n4 != n3) {
            for (n4 = n3; n4 < n2 && string.charAt(n4) != '\n'; ++n4) {
            }
        }
        if (n4 == n) {
            return null;
        }
        return string.substring(++n, n4);
    }

    private static void _a_(String string) {
        Editor._a_(string);
    }

    private static void _e_(String string) {
        Editor._e_(string);
    }
}

