/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Constants;
import GUI.Editor;
import GUI.InputTextArea;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public final class InitFile {
    private static String pwdfile = System.getProperty("user.dir") + File.separator + "input.txt";
    private static String initrc = System.getProperty("user.home") + File.separator + ".ioprc";

    public static String getInitFile() {
        BufferedReader bufferedReader;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(pwdfile));
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                InitFile._a_("Cannot close file \"" + pwdfile + "\".");
            }
            string = pwdfile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            InitFile._a_("Cannot find file \"" + pwdfile + "\".");
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(initrc));
        }
        catch (FileNotFoundException fileNotFoundException) {
            InitFile._a_("Cannot find file \"" + initrc + "\".");
            return string;
        }
        try {
            if (string == null) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    return string;
                }
                File file = new File(string2);
                if (file.isFile()) {
                    string = string2;
                    InitFile.processPreferences(bufferedReader);
                    bufferedReader.close();
                } else {
                    InitFile.processPreferences(string2, bufferedReader);
                }
            }
        }
        catch (IOException iOException) {
            InitFile._a_("Couldn't read from \"" + initrc + "\".");
            return string;
        }
        return string;
    }

    public static void processPreferences(String string, BufferedReader bufferedReader) {
        InitFile.processPreferenceString(string);
        InitFile.processPreferences(bufferedReader);
    }

    public static void processPreferences(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                InitFile.processPreferenceString(string);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void processPreferenceString(String string) {
        if (string.trim().indexOf(35) == 0) {
            return;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n - 1).trim().toLowerCase();
        String string3 = string.substring(n + 1).trim();
        if (string2.equals("window height")) {
            int n2 = Integer.parseInt(string3);
            Constants.setHeight(n2);
            return;
        }
        if (string2.equals("window width")) {
            int n3 = Integer.parseInt(string3);
            Constants.setWidth(n3);
            return;
        }
        if (string2.equals("font style")) {
            if (string3.equalsIgnoreCase("bold")) {
                Constants.setFontStyle(1);
            }
            if (string3.equalsIgnoreCase("plain")) {
                Constants.setFontStyle(0);
            }
            return;
        }
        if (string2.equals("show font familes")) {
            if (string3.equalsIgnoreCase("true")) {
                InitFile.showAllFontFamilies();
            }
            return;
        }
        if (string2.equals("font size")) {
            int n4 = Integer.parseInt(string3);
            Constants.setFontSize(n4);
            return;
        }
        if (string2.equals("double click sends line")) {
            InputTextArea.setDoubleClickEnabled(Boolean.parseBoolean(string3));
            return;
        }
    }

    public static void showAllFontFamilies() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        System.err.println("The available font familes are:");
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println("\t" + stringArray[i]);
        }
        System.err.println("Hope you find one that looks OK!");
    }

    public static void main(String[] stringArray) {
        System.out.println(InitFile.getInitFile());
        System.out.println(initrc);
    }

    private InitFile() {
    }

    private static void _a_(String string) {
        Editor._a_(string);
    }
}

